// CLKBSDK_DEMODlg.cpp : implementation file
//

#include "stdafx.h"
#include "CLKBSDK_DEMO.h"
#include "CLKBSDK_DEMODlg.h"
#include "LKBSDK.h"

//#include <winreg.h>
//#include <winspool.h>

#define	LK_SUCCESS		0L

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCLKBSDK_DEMODlg dialog

CCLKBSDK_DEMODlg::CCLKBSDK_DEMODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCLKBSDK_DEMODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCLKBSDK_DEMODlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCLKBSDK_DEMODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCLKBSDK_DEMODlg)
	DDX_Control(pDX, IDC_COMBO_PRINTERNAME, m_cboPrinterName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCLKBSDK_DEMODlg, CDialog)
	//{{AFX_MSG_MAP(CCLKBSDK_DEMODlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PRINT_WINDOWS_FONT_BTN, OnPrintWindowsFontBtn)
	ON_BN_CLICKED(IDC_PRINT_BMP_BTN, OnPrintBmpBtn)
	ON_BN_CLICKED(IDC_PRINT_PCX_BTN, OnPrintPcxBtn)
	ON_BN_CLICKED(IDC_PRINT_DEVICE_FONT_BTN, OnPrintDeviceFontBtn)
	ON_BN_CLICKED(IDC_PRINT_BARCODE_BTN, OnPrintBarcodeBtn)
	ON_BN_CLICKED(IDC_PRINT_LINE_BTN, OnPrintLineBtn)
	ON_BN_CLICKED(IDC_PRINT_DATE_BTN, OnPrintDateBtn)
	ON_BN_CLICKED(IDC_PRINT_TIME_BTN, OnPrintTimeBtn)
	ON_BN_CLICKED(IDC_TEST_ALL, OnTestAll)
	ON_BN_CLICKED(IDC_PRINT_PDF417, OnPrintPdf417)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCLKBSDK_DEMODlg message handlers

BOOL CCLKBSDK_DEMODlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	long version;
	char temp[128];
	version=LK_GetVersion();
	sprintf(temp,"LKBSDK Version : %X.%02X",version>>8,version&0xff);
	CWnd::SetDlgItemText(IDC_STATIC_VER,(LPCTSTR)temp);	

	m_cboPrinterName.AddString("LUKHAN Label Printer");
	m_cboPrinterName.AddString("SEWOO Label Printer");
	m_cboPrinterName.SetCurSel(1); // SEWOO Label Printer

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCLKBSDK_DEMODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCLKBSDK_DEMODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCLKBSDK_DEMODlg::OnPrintWindowsFontBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int nHeight;
	int nWidth;
	int x,y;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
#if 1 // Gap Test
	rtn=LK_SetupPrinter("101.6",	// 10 ~ 104 (Unit is mm)
					"152.4", 		// 5 ~ 350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);
#else // BlackMark Test
	rtn=LK_SetupPrinter("101.6",	// 10 ~ 104 (Unit is mm)
					"82", 		// 5 ~ 350 (Unit is mm)
					1,				// 0=Label with Gap, 1=Label width Black Mark
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);
#endif
	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();
		nHeight=31;
		x=80;
//		y=240;
		y=180;
		LK_PrintWindowsFont(x,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,1,0,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,0,1,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,1,1,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,0,1,1,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,1,1,1,"Arial","Korea Mountain & River"); y+=80;

		nWidth=24;
		LK_PrintWindowsFontPitch(x,y,0,nHeight,nWidth,1,1,1,"Arial","Korea Mountain & River"); y+=80;
	LK_EndPage();
#if 0
	/* 3-2. page 2 test */
	LK_StartPage();
		nHeight=62;
		x=80;
		y=240;
		LK_PrintWindowsFont(x,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,1,0,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,0,1,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,1,1,0,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,0,1,1,"Arial","Korea Mountain & River"); y+=80;
		LK_PrintWindowsFont(x,y,0,nHeight,1,1,1,"Arial","Korea Mountain & River"); y+=80;
	LK_EndPage();
#endif
	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

void CCLKBSDK_DEMODlg::OnPrintBmpBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	x=10*8;
	y=10*8;
	LK_StartPage();
		LK_PrintBMP(x,y,"Red.bmp");		
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

void CCLKBSDK_DEMODlg::OnPrintPcxBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	x=10*8;
	y=10*8;
	LK_StartPage();
		LK_PrintPCX(x,y,"RING.PCX");	
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

char *test_str="SEWOO TECH";
void CCLKBSDK_DEMODlg::OnPrintDeviceFontBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();
		x=50*8;
		y=50*8;
		/* 0  */
		LK_PrintDeviceFont(x,y,0,3,1,1,0,PrinterName);
		/* 90  */
		LK_PrintDeviceFont(x,y,90,3,1,1,0,PrinterName);
		/* 180  */
		LK_PrintDeviceFont(x,y,180,3,1,1,0,PrinterName);
		/* 270  */
		LK_PrintDeviceFont(x,y,270,3,1,1,0,PrinterName);
		/* reverse */
		x=10*8;
		y=90*8;
		LK_PrintDeviceFont(x,y,0,3,2,2,1,PrinterName);
		/* reverse */
		y=100*8;
		LK_PrintDeviceFont(x,y,0,1,1,1,0,PrinterName);
		y += 5*8;
		LK_PrintDeviceFont(x,y,0,2,1,1,0,PrinterName);
		y += 6*8;
		LK_PrintDeviceFont(x,y,0,3,1,1,0,PrinterName);
		y += 7*8;
		LK_PrintDeviceFont(x,y,0,4,1,1,0,PrinterName);
		y += 8*8;
		LK_PrintDeviceFont(x,y,0,5,1,1,0,test_str);
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

/* 
			>>>> Barcode Spec. for EPL2 <<<<

+------+--------------------------------------------------+------------------+
| Bar  |                Description                       | Narrow bar width |
| Code |                                                  |  width in dots   |
+------+--------------------------------------------------+------------------+
|  3   |Code 39 std. or extended                          |     1 ~ 10       |
|  3C  |Code 39 with check digit                          |     1 ~ 10       |
|  93  |Code 93                                           |     1 ~ 10       |
|  0   |Code 128 UCC Serial Shipping Container Code       |     1 ~ 10       |
|  1   |Code 128 auto A, B, C modes                       |     1 ~ 10       |
|  1A  |Code 128 mode A                                   |     1 ~ 10       |
|  1B  |Code 128 mode B                                   |     1 ~ 10       |
|  1C  |Code 128 mode C                                   |     1 ~ 10       |
|  K   |Codabar                                           |     1 ~ 10       |
|  E80 |EAN8                                              |     2 ~ 4        |
|  E82 |EAN8 2 digit add-on                               |     2 ~ 4        |
|  E85 |EAN8 5 digit add-on                               |     2 ~ 4        |
|  E30 |EAN13                                             |     2 ~ 4        |
|  E32 |EAN13 2 digit add-on                              |     2 ~ 4        |
|  E35 |EAN13 5 digit add-on                              |     2 ~ 4        |
|  2G  |German Post Code                                  |     3 ~ 4        |
|  2   |Interleaved 2 of 5                                |     1 ~ 10       |
|  2C  |Interleaved 2 of 5 with mod 10 check digit        |     1 ~ 10       |
|  2D  |Interleaved 2 of 5 with human readable check digit|     1 ~ 10       |
|  P   |Postnet 5, 9, 11 & 13 digit                       |       __         |
|  PL  |Planet 11 & 13 digit                              |       __         |
|  J   |Japanese Postnet                                  |       __         |
|  1E  |UCC/EAN 128                                       |     1 ~ 10       |
|  UA0 |UPC A                                             |     2 ~ 4        |
|  UA2 |UPC A 2 digit add-on                              |     2 ~ 4        |
|  UA5 |UPC A 5 digit add-on                              |     2 ~ 4        |
|  UE0 |UPC E                                             |     2 ~ 4        |
|  UE2 |UPC E 2 digit add-on                              |     2 ~ 4        |
|  UE5 |UPC E 5 digit add-on                              |     2 ~ 4        |
|  2U  |UPC Interleaved 2 of 5                            |     1 ~ 10       |
|  L   |Plessey (MSI-1) with mod. 10 check digit          |       __         |
|  M   |MSI-3 with mod. 10 check digit                    |       __         |
+------+--------------------------------------------------+------------------+
*/
char *test_str3="Code128 AutoA";
char *code_128a="6015343013149";

char *PDF417_data="SEWOO PDF417 TEST 01SEWOO PDF417 TEST 01SEWOO PDF417 TEST 01SEWOO PDF417 TEST 01SEWOO PDF417 TEST 01SEWOO PDF417 TEST 01SEWOO PDF417 TEST 01";
char *QRCode_data="SEWOO QRCode TEST";
char *DataMatrix_data="SEWOO DataMatrix TEST";

void CCLKBSDK_DEMODlg::OnPrintBarcodeBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y,BarHeight;
	CString strPrinterName;
	char	PrinterName[64];

	int	xdots, ydots, model;
	int xwidthdot, ywidthdot;
//	char	TwoBAR_Command[128];
	char	TwoBAR_Command[256 + 128];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();
		BarHeight=12*8;	// 12mm
		x=10*8;
		y=10*8;
		LK_PrintDeviceFont(x,y,0,3,1,1,0,test_str3);
		/* 0  */
		x=50*8;
		y=60*8;
//		LK_PrintBarCode(x,y,0,"1",2,0,BarHeight,1,code_128a);
		LK_PrintBarCode(x,y,0,"2",2,4,BarHeight,1,code_128a);
		/* 90  */
		x=50*8-2*8;
		y=60*8;
//		LK_PrintBarCode(x,y,90,"1",2,0,BarHeight,1,code_128a);
		LK_PrintBarCode(x,y,90,"2",2,4,BarHeight,1,code_128a);
		/* 1800  */
		x=50*8-2*8;
		y=60*8-2*8;
//		LK_PrintBarCode(x,y,180,"1",2,0,BarHeight,1,code_128a);
		LK_PrintBarCode(x,y,180,"2",2,4,BarHeight,1,code_128a);
		/* 270  */
		x=50*8;
		y=60*8-2*8;
//		LK_PrintBarCode(x,y,270,"1",2,0,BarHeight,1,code_128a);
		LK_PrintBarCode(x,y,270,"2",2,4,BarHeight,1,code_128a);


		memset(TwoBAR_Command, 0, sizeof(TwoBAR_Command));
		x=10*8;
//		x=0;
		y=100*8;
		xdots = 3;
		ydots = xdots * 3;
		xwidthdot = 800; // ü  .( ū )
		ywidthdot = 600; // ü  .( ū )
		wsprintf(TwoBAR_Command, "b%d,%d,%c,%d,%d,s0,c0,f0,x%d,y%d,l3,t0,o0,\"%s\"\r\n", x, y, 'P', xwidthdot, ywidthdot, xdots, ydots, PDF417_data);
		LK_DirectCommand(TwoBAR_Command);

		// QR Code
		// bx,y,Q,1,z,L,"DATA"
		// x = x position.
		// y = y position
		// z = Cell Size. (2 ~ 16)
		// L = ECC Level(L or M or Q or H)
		memset(TwoBAR_Command, 0, sizeof(TwoBAR_Command));
		x=60*8;
		y=100*8;
		xdots = 3;
		model = 1;
		wsprintf(TwoBAR_Command, "b%d,%d,%c,%d,%d,%c,\"%s\"\r\n", x, y, 'Q', model, xdots, 'L', QRCode_data);
		LK_DirectCommand(TwoBAR_Command);

		// DataMatrix
		// bx,y,D,r,c,"DATA"
		// x = x position.
		// y = y position
		// r = Rotate. (0 ~ 3)
		// c = Cell size
		memset(TwoBAR_Command, 0, sizeof(TwoBAR_Command));
		x=80*8;
		y=100*8;
		xdots = 3;
		wsprintf(TwoBAR_Command, "b%d,%d,%c,%d,%d,\"%s\"\r\n", x, y, 'D', 0, xdots, DataMatrix_data);
		LK_DirectCommand(TwoBAR_Command);

		/* 0 , No readable */
/*
		x=10*8;
		y=115*8;
		LK_PrintDeviceFont(x,y,0,3,1,1,0,"Human readable=No");
		y=120*8;
		LK_PrintBarCode(x,y,0,"1",2,0,BarHeight,0,code_128a);
*/
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

void CCLKBSDK_DEMODlg::OnPrintLineBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	int	nHeight;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();

		x=10*8;
		y=10*8;
		LK_PrintLine(x,y,50*8,2*8);

		x=10*8;
		y=15*8;
		LK_DrawLine(PS_SOLID, x,y,x+50*8, y, 16);

		x=10*8;
		y=20*8;
		LK_PrintDiagonalLine(x,y,x+50*8,y+30*8,2*8);

		x=20*8;
		y=20*8;
		LK_DrawLine(PS_SOLID, x,y,x+50*8,y+30*8, 16);

		x=30*8;
		y=20*8;
		LK_DrawLine(PS_DASH, x,y,x+50*8,y+30*8, 4);

		x=40*8;
		y=20*8;
		LK_DrawLine(PS_DOT, x,y,x+50*8,y+30*8, 4);

		x=50*8;
		y=20*8;
		LK_DrawLine(PS_DASHDOT, x,y,x+50*8,y+30*8, 4);

		x=60*8;
		y=20*8;
		LK_DrawLine(PS_DASHDOTDOT, x,y,x+30*8,y+18*8, 4);

		x=70*8;
		y=20*8;
		LK_DrawLine(PS_DASH, x,y,x+20*8,y, 4);


		x=10*8;
		y=60*8;
		LK_Rectangle(PS_DOT, x, y, x+50*8, y+20*8, 4);	
		x=70*8;
		y=60*8;
		LK_Rectangle(PS_SOLID, x, y, x+20*8, y+4, 4);	
		x=10*8;
		y=90*8;
		LK_Ellipse(PS_DOT, x, y, x+30*8, y+30*8, 4);	

		x=40*8;
		y=90*8;
		LK_DrawLine(PS_DASH, x,y,x+30*8,y+30*8, 4);
		x=50*8;
		y=90*8;
		LK_DrawLine(PS_DOT, x,y,x+30*8,y+30*8, 4);
		x=60*8;
		y=90*8;
		LK_DrawLine(PS_DASHDOT, x,y,x+30*8,y+30*8, 4);

		nHeight=56;
		x=50*8;
		y=52*8;
#if 1 // Center Align Test
		LK_PrintWindowsFontAlign(1,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); // Center Align
#else
		LK_PrintWindowsFontAlign(0,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); // Left Align
#endif

	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

void CCLKBSDK_DEMODlg::OnPrintDateBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();
		x=50*8;
		y=50*8;
		/* 0  */
		LK_PrintDate(x,y,0,3*8,0,0,0,"Arial",0);
		/* 90  */
		LK_PrintDate(x,y,90,3*8,0,0,0,"Arial",0);
		/* 180  */
		LK_PrintDate(x,y,180,3*8,0,0,0,"Arial",0);
		/* 270  */
		LK_PrintDate(x,y,270,3*8,0,0,0,"Arial",0);

		x=50*8;
		y=80*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",0); y+=5*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",1); y+=5*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",2); y+=5*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",3); y+=5*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",4); y+=5*8;
		LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",5); y+=5*8;
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

void CCLKBSDK_DEMODlg::OnPrintTimeBtn() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	CString strPrinterName;
	char	PrinterName[64];

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	memset(PrinterName, 0, sizeof(PrinterName));
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();
		x=50*8;
		y=50*8;
		/* 0  */
		LK_PrintTime(x,y,0,3*8,0,0,0,"Arial",1);
		/* 90  */
		LK_PrintTime(x,y,90,3*8,0,0,0,"Arial",1);
		/* 180  */
		LK_PrintTime(x,y,180,3*8,0,0,0,"Arial",1);
		/* 270  */
		LK_PrintTime(x,y,270,3*8,0,0,0,"Arial",1);

		x=50*8;
		y=80*8;
		LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",0); y+=5*8;
		LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",1); y+=5*8;
		LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",2); y+=5*8;
		LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",3); y+=5*8;
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}

void CCLKBSDK_DEMODlg::OnTestAll() 
{
	// TODO: Add your control notification handler code here
	
	OnPrintWindowsFontBtn();
	OnPrintBmpBtn();
	OnPrintPcxBtn();
	OnPrintDeviceFontBtn();
	OnPrintBarcodeBtn();
	OnPrintLineBtn();
	OnPrintDateBtn();
	OnPrintTimeBtn();
	OnPrintPdf417();
}

char *pdf417_data="SEWOO PDF417 TEST";

void CCLKBSDK_DEMODlg::OnPrintPdf417() 
{
	// TODO: Add your control notification handler code here
	
	long rtn;
	int x,y;
	int xwidthdot, ywidthdot;
	int	xdots, ydots;
	CString strPrinterName;
	char	PrinterName[64];
	char	PDF417_Command[128];

	memset(PrinterName, 0, sizeof(PrinterName));
	memset(PDF417_Command, 0, sizeof(PDF417_Command));

	// Get the Printer Driver Name.
	m_cboPrinterName.GetLBText(m_cboPrinterName.GetCurSel(), strPrinterName);
	sprintf(PrinterName, "%s", strPrinterName);
	/* 1. LK_OpenPrinter() */
	if(LK_OpenPrinter(PrinterName) != LK_SUCCESS){
		return;
	}

	/* 2. LK_SetupPrinter() */
	rtn=LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
					"152.4", 		// 5~350 (Unit is mm)
					0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);

	if(rtn != LK_SUCCESS){
		LK_ClosePrinter();
		return;
	}

	/* 3-1. page 1 test */
	LK_StartPage();
		x=10*8;
		y=10*8;
		xdots = 3;
		ydots = xdots * 3;
		xwidthdot = 800; // ü  .( ū )
		ywidthdot = 400; // ü  .( ū )
		wsprintf(PDF417_Command, "b%d,%d,%c,%d,%d,s0,c0,f0,x%d,y%d,l3,t0,o0,\"%s\"\r\n", x, y, 'P', xwidthdot, ywidthdot, xdots, ydots, pdf417_data);
		LK_DirectCommand(PDF417_Command);
	LK_EndPage();

	/* 4. LK_ClosePrinter() */
	LK_ClosePrinter();
}
